set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 12

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	drop if D1_LP1_EMP==.
	
	*Standardize TFP 
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
	sum D1_LP1_EMP [w=weight_VA_c]

	gen decade=1970 if year<=1980
	replace decade=8000 if year>1980

	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)	
save $path_temp\temp_T12, replace

		
**2. Table 12, top panel 1970s
use $path_temp\temp_T12, clear
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T12_$col
				lincomest D1_LP1_EMP +  L.D1_LP1_EMP + L2.D1_LP1_EMP             
				estimates store ownd1_$col
				est restore T12_$col	
	end	
	
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP"
	local dec		"decade==1970"
	local controls1	"i.country*year i.country*i.bcycle"
	local controls2	"i.sectorgroup i.country*year i.country*i.bcycle"

	**Column A: Employment
		global col=1
		qui xi:areg D1_lnEMP  `own' `controls1' [w=weight_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnEMP  `own' `controls2' [w=weight_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	**Column B: Hours worked
		global col=3
		qui xi:areg D1_lnH_EMP  `own' `controls1' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=4
		qui xi:areg D1_lnH_EMP  `own' `controls2' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	**Column C: Nominal wage bill
		global col=5
		qui xi:areg D1_lnLAB  `own' `controls1' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnLAB  `own' `controls2' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	*Table
	esttab T12_1 T12_2 T12_3 T12_4 T12_5 T12_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1970s, top panel")
	
	foreach var in ownd1   {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1970s, top panel")
		}	
	

**3. Table 12, top panel 1980s-2000s
use $path_temp\temp_T12, clear		
tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T12_$col
				lincomest D1_LP1_EMP +  L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP         
				estimates store ownd2_$col
				est restore T12_$col								
	end	
	
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local dec		"decade==8000"
	local controls1	"i.country*year i.country*i.bcycle"
	local controls2	"i.sectorgroup i.country*year i.country*i.bcycle"

	**Column A: Employment
		global col=1
		qui xi:areg D1_lnEMP  `own' `controls1' [w=weight_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnEMP  `own' `controls2' [w=weight_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	**Column B: Hours worked
		global col=3
		qui xi:areg D1_lnH_EMP  `own' `controls1' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=4
		qui xi:areg D1_lnH_EMP  `own' `controls2' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	**Column C: Nominal wage bill
		global col=5
		qui xi:areg D1_lnLAB  `own' `controls1' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnLAB  `own' `controls2' [w=weight_h_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	*Table
	esttab T12_1 T12_2 T12_3 T12_4 T12_5 T12_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1980s-2000s, top panel")
	
	foreach var in ownd2   {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1980s-2000s, top panel")
		}	
				

**4. Table 12, bottom panel, 1970s
use $path_temp\temp_T12, clear
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T12_$col
				lincomest D1_LP1_EMP +  L.D1_LP1_EMP + L2.D1_LP1_EMP          
				estimates store ownd1_$col
				est restore T12_$col							
	end	
	
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP"
	local dec		"decade==1970"
	local controls1	"i.country*year i.country*i.bcycle"
	local controls2	"i.sectorgroup i.country*year i.country*i.bcycle"
	
	**Column D: Nominal value added
		global col=1
		qui xi:areg D1_lnVA  `own' `controls1' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnVA  `own' `controls2' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
			
	**Column E: Real value added
		global col=3
		qui xi:areg D1_lnVA_QI  `own' `controls1' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=4
		qui xi:areg D1_lnVA_QI  `own' `controls2' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	**Column F: Laborshare
		global col=5
		qui xi:areg D1_lnlaborshare  `own' `controls1' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnlaborshare  `own' `controls2' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		
	*Table
	esttab T12_1 T12_2 T12_3 T12_4 T12_5 T12_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1970s, bottom panel")
	
	foreach var in ownd1   {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1970s, bottom panel")
		}	
	


**5. Table 12, bottom panel, 1980s-2000s
use $path_temp\temp_T12, clear		
tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T12_$col
				lincomest D1_LP1_EMP +  L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP         
				estimates store ownd2_$col
				est restore T12_$col								
	end	
	
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local dec		"decade==8000"
	local controls1	"i.country*year i.country*i.bcycle"
	local controls2	"i.sectorgroup i.country*year i.country*i.bcycle"
	local controls3	"i.sectorgroup"

	**Column D: Nominal value added
		global col=1
		qui xi:areg D1_lnVA  `own' `controls1' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnVA  `own' `controls2' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
			
	**Column E: Real value added
		global col=3
		qui xi:areg D1_lnVA_QI  `own' `controls1' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=4
		qui xi:areg D1_lnVA_QI  `own' `controls2' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates

	**Column F: Laborshare
		global col=5
		qui xi:areg D1_lnlaborshare  `own' `controls1' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnlaborshare  `own' `controls2' [w=weight_VA_c] if `dec', absorb(year) clus(ic) 
			storeestimates
			

	*Table
	esttab T12_1 T12_2 T12_3 T12_4 T12_5 T12_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1980s-2000s, bottom panel")
	
	foreach var in ownd2   {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 12, 1980s-2000s, bottom panel")
		}	


*erase temporary files
	cap erase $path_temp\temp_T12.dta
